﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="System.Diagnostics" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.ComponentModel" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Place" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Kalend" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Oświadczenie ZUS Z-15a</title>
		<script runat="server">

    public class Params : ContextBase {
        Context context;
        public Params(Context cx) : base(cx) {
            context = cx;
        }

        CzlonekRodziny osoba;
        [Required]
        [Priority(10)]
        [Caption("Członek rodziny")]
        public CzlonekRodziny Osoba {
            get { return osoba; }
            set { osoba = value; }
        }

        public object GetListOsoba() {
            PracHistoria ph = (PracHistoria)context[typeof(PracHistoria)];
            return ph.Pracownik.Rodzina;
        }
    }

    Params param = null;
    [Context]
    public Params Param {
        get { return param; }
        set { param = value; }
    }
  
    string NBSP(string ss) {
		return ss=="" ? "&nbsp;" : ss;
    }

    void LiczDanePracownika(PracHistoria ph) {
        bool dowod = ph.Dokument.Rodzaj == KodRodzajuDokumentu.DowodOsobisty;
        if (ph.NIP == "" || ph.PESEL == "") {
            DOKRODZAJ.EditValue = ""; //dowod ? "1" : "2";
            DOKUBEZP.EditValue = ph.Dokument.SeriaNumer;
        }
        else {
            DOKRODZAJ.EditValue = ""; //NBSP("");
            DOKUBEZP.EditValue = NBSP("");
        }
        //Date ur = ph.Urodzony.Data;
        //if (ur != Date.Empty)
        //    URODZONY.EditValue = string.Format("{0}/{1}/{2}", ur.Day.ToString("D2"), ur.Month.ToString("D2"), ur.Year.ToString("D2"));
        IAdres adres = !ph.AdresZamieszkania.IsEmpty() ? ph.AdresZamieszkania : ph.AdresZameldowania;
        AdresKodPocztowyS.EditValue = adres.KodPocztowyS;
        //AdresPoczta.EditValue = adres.Poczta;
        //AdresGmina.EditValue = adres.Gmina;
        AdresMiejscowosc.EditValue = adres.Miejscowosc;
        AdresUlica.EditValue = adres.Ulica;
        AdresNrDomu.EditValue = adres.NrDomu;
        AdresNrLokalu.EditValue = adres.NrLokalu;
        AdresTelefon.EditValue = adres.Telefon;
        //AdresZagranicznyKodPocztowy.EditValue = adres.ZagranicznyKodPocztowy;
        AdresKraj.EditValue = adres.Kraj;
        //AdresMail.EditValue = "";
        if (ph.Pracownik.DomyslnyRachunek != null)
            RachunekBank.EditValue = ph.Pracownik.DomyslnyRachunek;
        else
            RachunekBank.EditValue = "&nbsp;";
    }
		
    void OnContextLoad(Object sender, EventArgs args) {
        dc.LeftMargin = dc.TopMargin = dc.RightMargin = dc.BottomMargin = 19;
        PracHistoria ph = (PracHistoria)dc[typeof(PracHistoria)];

        LiczDanePracownika(ph);
        
        CzlonekRodziny osoba = param.Osoba;
        OsobaPESEL.EditValue = osoba.PESEL;
        bool dowod = osoba.Dokument.Rodzaj == KodRodzajuDokumentu.DowodOsobisty;
        if (osoba.NIP == "" || osoba.PESEL == "") {
            OsobaDokRodzaj.EditValue = ""; //dowod ? "1" : "2";
            OsobaDokSeria.EditValue = osoba.Dokument.SeriaNumer;
        }
        else {
            OsobaDokRodzaj.EditValue = ""; //NBSP("");
            OsobaDokSeria.EditValue = NBSP("");
        }
        OsobaNazwisko.EditValue = osoba.Nazwisko;
        OsobaImie.EditValue = osoba.Imie;
        //OsobaPokrewienstwo.EditValue = osoba.StPokrewienstwa;
        Date ur = osoba.Urodzony.Data;
        if (ur != Date.Empty)
            OsobaUrodzony.EditValue = string.Format("{0}/{1}/{2}", ur.Day.ToString("D2"), ur.Month.ToString("D2"), ur.Year.ToString("D2"));
    }
	        
    public static void Msg(object obj) {
    }

</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body style="font-family: Tahoma">
		<form id="DeklaracjaZ15a" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad" TypeName="Soneta.KadryPlace"></ea:datacontext>
			<cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="OŚWIADCZENIE ZUS Z-15a" runat="server"></cc1:reportheader>
            <font face="Tahoma" size="3">
                <p style="text-align:center">
                    <b>WNIOSEK<br />
                    O ZASIŁEK OPIEKUŃCZY<br />
                    Z POWODU SPRAWOWANIA OPIEKI NAD DZIECKIEM</b>
                </p>
            </font>
            <font face="Tahoma" size="2">
                <p style="text-align:left">
                    <u><b>Instrukcja wypełniania</b></u><br />
                    Wypełnij ten wniosek, jeżeli jesteś rodzicem i ubiegasz się o wypłatę zasiłku opiekuńczego z powodu sprawowania opieki nad:<br />
                    – zdrowym dzieckiem do 8 lat,<br />
                    – chorym dzieckiem.<br />
                    Wypełnij ten wniosek również, jeżeli jesteś rodzicem lub członkiem rodziny dziecka i ubiegasz się o wypłatę
                    dodatkowego zasiłku opiekuńczego z powodu sprawowania opieki nad:<br />
                    – dzieckiem nowonarodzonym w okresie do 8 tygodni po porodzie, jeżeli ubezpieczona matka dziecka
                    przebywa w szpitalu/ porzuciła dziecko/ posiada orzeczenie o niezdolności do samodzielnej egzystencji/
                    niepełnosprawności w stopniu znacznym.<br />
                    <ol>
                        <li>Wypełnij WIELKIMI LITERAMI</li>
                        <li>Pola wyboru zaznacz znakiem <b>X</b></li>
                        <li>Wypełnij kolorem czarnym lub niebieskim (nie ołówkiem)</li>
                        <li>We wniosku podaj <u><b>adres do korespondencji</b></u> w tej sprawie</li>
                        <li>Zanim wypełnisz wniosek, zapoznaj się z dołączoną do niego Informacją</li>
                        <li>Jeżeli ubiegasz się o zasiłek opiekuńczy nad dzieckiem nowonarodzonym w okresie do 8 tygodni po porodzie,
                        we wniosku podaj okres oraz wypełnij tylko dane dziecka i swoje oraz punkt 1 w sekcji „Oświadczam, że”</li>
                        <li>Wypełniając punkt 4 w sekcji „Oświadczam, że” oraz punkt 2 w sekcji „Dane drugiego rodzica dziecka (matka
                        lub ojciec dziecka)” oraz „Dane Twojego małżonka” do liczby dni, z powodu sprawowania opieki nad dziećmi
                        do lat 14, nie wliczaj dodatkowego zasiłku, w wymiarze do 56 dni z powodu sprawowania opieki nad dzieckiem
                        nowonarodzonym, w okresie do 8 tygodni po porodzie</li>
                    </ol>
                </p>
                <u><b>Okres, za który ubiegasz się o zasiłek opiekuńczy</b></u><br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="70%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <font face="Tahoma" size="2">&nbsp;<br /></font>
						</TD>
                    </TR>
                </TABLE>
                <font face="Tahoma" size="1">
                    <i>Podaj datę lub daty (od–do), w których będziesz sprawował opiekę</i>
                </font>
                <br /><br />
                <u><b>Zwolnienie lekarskie</b></u><br />
                <font face="Tahoma" size="1">
                    <i>Wypełnij, jeżeli lekarz wystawił Ci zwolnienie lekarskie elektronicznie (e-ZLA)</i>
                </font>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="70%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <font face="Tahoma" size="2">&nbsp;<br /></font>
						</TD>
                    </TR>
                </TABLE>
                <font face="Tahoma" size="1">
                    <i>Podaj datę lub daty (od–do), oraz jeżeli znasz – serię i numer zwolnienia lekarskiego</i>
                </font>
                <br /><br />
                <u><b>Dane dziecka, nad którym sprawujesz opiekę</b></u><br/>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="35%" align="right"><FONT size="2">Numer PESEL</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="OsobaPESEL" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Rodzaj, seria i numer dokumentu<br />potwierdzającego tożsamość</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel id="OsobaDokRodzaj" runat="server"></ea:DataLabel>&nbsp;
							<ea:DataLabel id="OsobaDokSeria" runat="server"></ea:DataLabel></FONT>
                        </TD>
                    </TR>
					<TR>
						<TD width="35%" align="right">&nbsp;</TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%">
                            <FONT size="1"><i>Jeśli nie ma nadanego numeru PESEL, podaj serię i numer innego dokumentu</i></FONT>
                        </TD>
                    </TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Imię</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="OsobaImie" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Nazwisko</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="OsobaNazwisko" runat="server"></ea:DataLabel></FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Data urodzenia dziecka (dd/mm/rrrr)</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="OsobaUrodzony" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
                </TABLE>
                <br />
                <u><b>Dane wnioskodawcy</b></u><br/>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="35%" align="right"><FONT size="2">Numer PESEL</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel DataMember="PracHistoria.PESEL" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Rodzaj, seria i numer dokumentu<br />potwierdzającego tożsamość</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel id="DOKRODZAJ" runat="server"></ea:DataLabel>&nbsp;
							<ea:DataLabel id="DOKUBEZP" runat="server"></ea:DataLabel></FONT>
                        </TD>
                    </TR>
					<TR>
						<TD width="35%" align="right">&nbsp;</TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%">
                            <FONT size="1"><i>Jeśli nie ma nadanego numeru PESEL, podaj serię i numer innego dokumentu</i></FONT>
                        </TD>
                    </TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Imię</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel DataMember="PracHistoria.Imie" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Nazwisko</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel DataMember="PracHistoria.Nazwisko" runat="server"></ea:DataLabel></FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Ulica</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="AdresUlica" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="35%" align="right"><FONT size="2">Numer domu</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="20%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="AdresNrDomu" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
						<TD width="20%" align="right"><FONT size="2">Numer lokalu</FONT></TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="20%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="AdresNrLokalu" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Kod pocztowy</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="20%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="AdresKodPocztowyS" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
						<TD width="20%" align="right"><FONT size="2">Miejscowość</FONT></TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="20%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
						    <FONT size="2"><ea:DataLabel ID="AdresMiejscowosc" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
                </TABLE>
            </font>
			<ea:PageBreak id="PageBreak1" runat="server" Required="True"></ea:PageBreak>
            <font face="Tahoma" size="2">
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="35%" align="right"><FONT size="2">Nazwa państwa</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="AdresKraj" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right">&nbsp;</TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%">
                            <FONT size="1"><i>Podaj, jeśli Twój adres jest inny niż polski</i></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Telefon</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel ID="AdresTelefon" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right">&nbsp;</TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%">
                            <FONT size="1"><i>Podaj numer telefonu – to ułatwi nam kontakt w Twojej sprawie</i></FONT>
						</TD>
					</TR>
                </TABLE>
                <br />
                <u><b>Oświadczam, że</b></u><br/>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="70%">
                            <FONT size="2">1. Jest domownik mogący zapewnić opiekę dziecku w okresie, za który ubiegam się o zasiłek opiekuńczy</FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="10%"><FONT size="2">[  ] TAK</FONT></TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="10%"><FONT size="2">[  ] NIE</FONT></TD>
                    </TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="70%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <font face="Tahoma" size="2"><br /><br /></font>
						</TD>
                    </TR>
                </TABLE>
                <font face="Tahoma" size="1">
                    <i>Jeżeli <b>TAK</b>, podaj, w jakich dniach inny domownik może sprawować opiekę</i>
                </font>
                <br /><br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="70%">
                            <FONT size="2">2. Jeżeli zasiłek będzie wypłacał Ci ZUS, to podaj, czy jesteś zatrudniony w systemie pracy zmianowej</FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="10%"><FONT size="2">[  ] TAK</FONT></TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="10%"><FONT size="2">[  ] NIE</FONT></TD>
                    </TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="70%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <font face="Tahoma" size="2"><br /><br /></font>
						</TD>
                    </TR>
                </TABLE>
                <font face="Tahoma" size="1">
                    <i>Jeżeli <b>TAK</b>, podaj godziny pracy w okresie, za który ubiegasz się o zasiłek opiekuńczy</i>
                </font>
                <br /><br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="70%">
                            <FONT size="2">3. Jeżeli ubiegasz się o zasiłek z tytułu sprawowania opieki nad dzieckiem powyżej
                                14 lat, to podaj czy pozostajesz z nim we wspólnym gospodarstwie w okresie sprawowania opieki
                            </FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="10%"><FONT size="2">[  ] TAK</FONT></TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="10%"><FONT size="2">[  ] NIE</FONT></TD>
                    </TR>
                </TABLE>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="70%">
                            <FONT size="2">4. Jeżeli w danym roku kalendarzowym zmieniłeś płatnika składek, to podaj czy od
                                poprzedniego płatnika otrzymałeś zasiłek opiekuńczy:
                            </FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="10%"><FONT size="2">[  ] TAK</FONT></TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="10%"><FONT size="2">[  ] NIE</FONT></TD>
                    </TR>
                </TABLE>
                <br />
                <font face="Tahoma" size="1">
                    <i>Jeżeli <b>TAK</b>, to podaj liczbę dni:</i>
                </font>
                <br /><br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
                    <TR>
						<TD width="4%"><FONT size="2">[  ]</FONT></TD>
                        <TD valign="middle">
                            <FONT size="2" >
                                z tytułu opieki nad dziećmi w wieku do 14 lat za ..... dni,
                            </FONT>
                        </TD>
                    </TR>
                    <TR>
						<TD width="4%"><FONT size="2">[  ]</FONT></TD>
                        <TD valign="middle">
                            <FONT size="2">
                                z tytułu opieki nad chorymi dziećmi w wieku powyżej 14 lat lub chorym członkiem rodziny za ..... dni.
                            </FONT>
                        </TD>
                    </TR>
                </TABLE>
                <br />
                <u><b>Dane drugiego rodzica dziecka (matki lub ojca dziecka)</b></u><br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="35%" align="right"><FONT size="2">Numer PESEL</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel id="DataLabel15" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Rodzaj, seria i numer dokumentu<br />potwierdzającego tożsamość</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel id="DataLabel9" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel>&nbsp;
							<ea:DataLabel id="DataLabel13" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="35%">&nbsp;</TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%">
                            <FONT size="1"><i>Jeśli nie ma nadanego numeru PESEL, podaj serię i numer innego dokumentu</i></FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Imię</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel id="DataLabel17" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Nazwisko</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel id="DataLabel16" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
                    </TR>
                </TABLE>
                <br /><br/>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="28%">
                            <FONT size="2">1. Czy rodzic dziecka pracuje</FONT>
						</TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="8%"><FONT size="2">[  ] TAK</FONT></TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="8%"><FONT size="2">[  ] NIE</FONT></TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="30%">
                            <FONT size="2">Jeżeli <b>TAK</b>, to czy jest to praca w systemie zmianowym</FONT>
						</TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="8%"><FONT size="2">[  ] TAK</FONT></TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="8%"><FONT size="2">[  ] NIE</FONT></TD>
                    </TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="70%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <br /><br />
						</TD>
                    </TR>
                </TABLE>
                <font face="Tahoma" size="1">
                    <i>Jeżeli pracuje w systemie pracy zmianowej, podaj godziny pracy w okresie sprawowania opieki</i>
                </font>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="70%">
                            <FONT size="2">2. Czy w danym roku kalendarzowym otrzymał zasiłek opiekuńczy:
                            </FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="10%"><FONT size="2">[  ] TAK</FONT></TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="10%"><FONT size="2">[  ] NIE</FONT></TD>
                    </TR>
                </TABLE>
                <br />
                <font face="Tahoma" size="1">
                    <i>Jeżeli <b>TAK</b>, to podaj liczbę dni:</i>
                </font>
                <br /><br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
                    <TR>
						<TD width="4%"><FONT size="2">[  ]</FONT></TD>
                        <TD valign="middle">
                            <FONT size="2" >
                                z tytułu opieki nad dziećmi w wieku do 14 lat za ..... dni,
                            </FONT>
                        </TD>
                    </TR>
                    <TR>
						<TD width="4%"><FONT size="2">[  ]</FONT></TD>
                        <TD valign="middle">
                            <FONT size="2">
                                z tytułu opieki nad chorymi dziećmi w wieku powyżej 14 lat lub chorym członkiem rodziny za ..... dni.
                            </FONT>
                        </TD>
                    </TR>
                </TABLE>
                <br />
                <u><b>Dane Twojego małżonka</b></u><br />
                <FONT size="2"><i>Podaj dane małżonka, jeżeli nie jest on rodzicem dziecka</i></FONT>
                <br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="35%" align="right"><FONT size="2">Numer PESEL</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel id="DataLabel1" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Rodzaj, seria i numer dokumentu<br />potwierdzającego tożsamość</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel id="DataLabel2" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel>&nbsp;
							<ea:DataLabel id="DataLabel3" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="35%">&nbsp;</TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%">
                            <FONT size="1"><i>Jeśli nie ma nadanego numeru PESEL, podaj serię i numer innego dokumentu</i></FONT>
						</TD>
                    </TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Imię</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel id="DataLabel4" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Nazwisko</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel id="DataLabel5" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
                    </TR>
                </TABLE>
            </font>
            <br /><br /><br />
			<ea:PageBreak id="PageBreak2" runat="server" Required="False"></ea:PageBreak>
            <font face="Tahoma" size="2">
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="28%">
                            <FONT size="2">1. Czy małżonek pracuje</FONT>
						</TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="8%"><FONT size="2">[  ] TAK</FONT></TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="8%"><FONT size="2">[  ] NIE</FONT></TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="30%">
                            <FONT size="2">Jeżeli <b>TAK</b>, to czy jest to praca w systemie zmianowym</FONT>
						</TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="8%"><FONT size="2">[  ] TAK</FONT></TD>
						<TD width="2%">&nbsp;</TD>
						<TD width="8%"><FONT size="2">[  ] NIE</FONT></TD>
                    </TR>
                </TABLE>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="70%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <br /><br />
						</TD>
                    </TR>
                </TABLE>
                <font face="Tahoma" size="1">
                    <i>Jeżeli pracuje w systemie pracy zmianowej, podaj godziny pracy w okresie sprawowania opieki</i>
                </font>
                <br /><br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="70%">
                            <FONT size="2">2. Czy w danym roku kalendarzowym otrzymał zasiłek opiekuńczy:
                            </FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="10%"><FONT size="2">[  ] TAK</FONT></TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="10%"><FONT size="2">[  ] NIE</FONT></TD>
                    </TR>
                </TABLE>
                <br />
                <font face="Tahoma" size="1">
                    <i>Jeżeli <b>TAK</b>, to podaj liczbę dni:</i>
                </font>
                <br /><br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
                    <TR>
						<TD width="4%"><FONT size="2">[  ]</FONT></TD>
                        <TD valign="middle">
                            <FONT size="2" >
                                z tytułu opieki nad dziećmi w wieku do 14 lat za ..... dni,
                            </FONT>
                        </TD>
                    </TR>
                    <TR>
						<TD width="4%"><FONT size="2">[  ]</FONT></TD>
                        <TD valign="middle">
                            <FONT size="2">
                                z tytułu opieki nad chorymi dziećmi w wieku powyżej 14 lat lub chorym członkiem rodziny za ..... dni.
                            </FONT>
                        </TD>
                    </TR>
                </TABLE>
                <br />
                <u><b>Dane innego członka rodziny</b></u>
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="70%">
                            <FONT size="2">Czy inny członek rodziny otrzymał zasiłek opiekuńczy z tytułu sprawowania opieki
                                nad Twoimi dziećmi w danym roku kalendarzowym:
                            </FONT>
						</TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="10%"><FONT size="2">[  ] TAK</FONT></TD>
						<TD width="5%">&nbsp;</TD>
						<TD width="10%"><FONT size="2">[  ] NIE</FONT></TD>
                    </TR>
                </TABLE>
                <font face="Tahoma" size="1">
                    <i>Jeżeli <b>TAK</b>, podaj jego dane oraz liczbę dni zasiłku opiekuńczego:</i>
                </font>
                <br /><br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="35%" align="right"><FONT size="2">Numer PESEL</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel id="DataLabel28" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Rodzaj, seria i numer dokumentu<br />potwierdzającego tożsamość</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2">
                                <ea:DataLabel id="DataLabel29" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel>&nbsp;
							    <ea:DataLabel id="DataLabel30" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel>
                            </FONT>
                        </TD>
                    </TR>
					<TR>
						<TD width="35%" align="right">&nbsp;</TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%">
                            <FONT size="1"><i>Jeśli nie ma nadanego numeru PESEL, podaj serię i numer innego dokumentu</i></FONT>
                        </TD>
                    </TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Imię</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel id="DataLabel32" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
					</TR>
					<TR>
						<TD width="35%" align="right"><FONT size="2">Nazwisko</FONT></TD>
						<TD width="3%">&nbsp;</TD>
						<TD width="62%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <FONT size="2"><ea:DataLabel id="DataLabel31" Format="{0}&amp;nbsp;" runat="server"></ea:DataLabel></FONT>
						</TD>
                    </TR>
                </TABLE>
                <br />
                otrzymał zasiłek opiekuńczy z tytułu sprawowania opieki nad Twoimi dziećmi za ..... dni.
                <br /><br />
                <u><b>Uwagi</b></u><br />
				<TABLE cellSpacing="0" cellPadding="0" width="95%" border="0">
					<TR>
						<TD width="70%" style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                            <br /><br /><br />
						</TD>
                    </TR>
                </TABLE>
                <br />
                <u><b>Zasiłek proszę przekazać na rachunek bankowy</b></u><br />
				<TABLE id="Table4" cellSpacing="0" cellPadding="0" width="95%" border="0" style="font-size: 10pt; font-family: tahoma">
					<TR>
						<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                        	<ea:DataLabel id="RachunekBank" runat="server"></ea:DataLabel>
						</TD>
					</TR>
                </TABLE>
                <br />
                <b>Oświadczam, że dane zawarte we wniosku podałem zgodnie z prawdą. Jeżeli ulegną one zmianie,
                zobowiązuję się poinformować o nich płatnika zasiłku.</b>
                <br /><br />
			    <cc1:reportfooter id="ReportFooter1" runat="server" TheEnd="true">
				    <Subtitles>
					    <cc1:FooterSubtitle Caption="Data: dd/mm/rrrr" Width="40"></cc1:FooterSubtitle>
					    <cc1:FooterSubtitle Caption="Czytelny podpis" Width="60"></cc1:FooterSubtitle>
				    </Subtitles>
			    </cc1:reportfooter>
			</font>
		</form>
	</body>
</HTML>
